package main

import (
	"fmt"
	"strconv"
)

// Zdefiniuj interfejs typu sparametryzowanego o nazwie Printable, dopasowujący
// typ, który implementuje fmt.Stringer i posiadający typ bazowy int lub
// float64. Zdefiniuj typy zgodne z tym interfejsem. Utwórz funkcję pobierającą
// interfejs Printable i wyświetlającą jej wartość na ekranie za pomocą
// fmt.Println.

type Printable interface {
	fmt.Stringer
	~int | ~float64
}

type PrintInt int

func (pi PrintInt) String() string {
	return strconv.Itoa(int(pi))
}

type PrintFloat float64

func (pf PrintFloat) String() string {
	return fmt.Sprintf("%f", pf)
}

func PrintIt[T Printable](t T) {
	fmt.Println(t)
}

func main() {
	var i PrintInt = 20
	PrintIt(i)

	var f PrintFloat = 10.23
	PrintIt(f)
}
